<!DOCTYPE html>

<html lang="en">

<?php
require_once("connect-db.php");

    if($_SERVER["REQUEST_METHOD"] == "POST"){
        $first = $_POST["first"];
        $last = $_POST["last"];
        $email = $_POST["email"];
        $phone = $_POST["phone"];
        $phone_type = $_POST["phone_type"];
        $message = $_POST["message"];
        $type = $_POST["type"];
        $type_extract = implode(", ", $type);
        $price_range = $_POST["price_range"];
    }
    
    $sql = "insert into user(first, last, email, phone, phone_type, message, type, price_range) values (:first, :last, :email, :phone, :phone_type, :message, :type, :price_range)";
    $statement = $db->prepare($sql);
    $statement->bindValue(":first", $first);
    $statement->bindValue(":last", $last);
    $statement->bindValue(":email", $email);
    $statement->bindValue(":phone", $phone);
    $statement->bindValue(":phone_type", $phone_type);
    $statement->bindValue(":message", $message);
    $statement->bindValue(":type", $type_extract);
    $statement->bindValue(":price_range", $price_range);
    if($statement->execute()){
        $statement->closeCursor();
    }

    $userId = $db->lastInsertId();
    $userQuery = $db->query("select type, price_range from user where user_id = $userId");
    $user = $userQuery->fetch();

    $preference = $user['type'];
    $max_price = $user['price_range'];

    $homesQuery = $db->query("select * from house where type = '$preference' and price <= '$max_price'");
?>

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title>D&B Realty</title>
	<link href="stylesheet.css" rel="stylesheet" type="text/css">
</head>

<body>
    <div class="container">
        <?php include("header_nav.html");?>
        <main>
            <h2>Other Options You May Like:</h2>
            <table>
                <?php
                    foreach($homesQuery as $h){
                ?>
                <tr>
                    <td>
                        <img src="<?php echo $h["img"];?>">
                    </td>
                    <td>
                        <p>$<?php echo $h["price"];?></p>
                        <p><?php echo $h["bedrooms"];?> bedroom(s)</p>
                        <p><?php echo $h["bathrooms"];?> bathroom(s)</p>
                        <p><?php echo $h["home_footage"];?> sq feet</p>
                        <p><?php echo $h["land_footage"];?> sq foot lot</p>
                        <p><?php echo $h["address"];?>, <?php echo $h["city"];?>, <?php echo $h["state"];?></p>
                        <p>Property Type: <?php echo $h["type"];?></p>
                        <p>HOA Fees: $<?php echo $h["fees"];?>/mo</p>
                        <form action="contact.php" method="POST">
                            <input type="hidden" name="home_id" value="<?php echo $h["home_id"];?>">
                            <button type="submit">Request More Information</button>
                        </form>
                    </td>
                </tr>
                <?php
                    }
                ?>
            </table>
        </main>

        <?php include("footer.html");?>
    </div>
</body>

</html>